#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Cloudy Sky with StarsMod01.fsh   by  bhpcv252  
//https://www.shadertoy.com/view/fsSfD3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define NS 100.
#define CI 0.3

float N21(vec2 p) {
    return fract(sin(p.x*100.+p.y*7446.)*8345.);
}

float SS(vec2 uv) {
    vec2 lv = fract(uv);
    lv = lv*lv*(3.-2.*lv);
    vec2 id = floor(uv);
    
    float bl = N21(id);
    float br = N21(id+vec2(1., 0.));
    float b = mix(bl, br, lv.x);

    float tl = N21(id+vec2(0., 1.));
    float tr = N21(id+vec2(1., 1.));
    float t = mix(tl, tr, lv.x);

    return mix(b, t, lv.y);
}

float L(vec2 uv, vec2 ofs, float b, float l) {
    return smoothstep(0., 1000., b*max(0.1, l)/pow(max(0.0000000000001, length(uv-ofs)), 1./max(0.1, l)));
}

float rand(vec2 co, float s){
    float PHI = 1.61803398874989484820459;
    return fract(tan(distance(co*PHI, co)*s)*co.x);
}

vec2 H12(float s) {
    float x = rand(vec2(243.234,63.834), s)-.5;
    float y = rand(vec2(53.1434,13.1234), s)-.5;
    return vec2(x, y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy;

    uv -= .5;
    uv.x *= iResolution.x/iResolution.y;
    
   
    
    vec4 col = vec4(.0);
    
    vec4 b = vec4(0.01176470588, 0.05098039215, 0.14117647058, 1.);
    vec4 p = vec4(0.13333333333, 0.07843137254, 0.13725490196, 1.);
    vec4 lb = vec4(0.10196078431, 0.21568627451, 0.33333333333, 1.);
    
    vec4 blb = mix(b, lb, -uv.x*.2-(uv.y*.5));
    
    col += mix(blb, p, uv.x-(uv.y*1.5));
    
    for(float i=0.; i < NS; i++) {
    
        vec2 ofs = H12(i+1.);
        ofs *= vec2(1.8, 1.1);
        float r = (mod(i, 20.) == 0.)? 0.5+abs(sin(i/50.)): 0.25;
        col += vec4(L(uv, ofs, r+(sin(fract(iTime)*.5*i)+1.)*0.02, 1.));
    }
    
    uv.x += iTime*.03;
    uv.y += sin(iTime*.03);
    
    
    float c = 0.;
    
    for(float i = 1.; i < 8.; i+=1.) {
        c += SS(uv*pow(2.,i))*pow(0.5, i);
    }
    
    col = col + c * CI;

    fragColor = col;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

